// IntrinsicControl.cpp : implementation file
//
#include "stdafx.h"
#include "script.h"
#include "IntrinsicControl.h"
#include "utility.h"
#include "CStringEx.h"

#undef _DEBUG // EMP DIKEO

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern class CScriptEngine *pENGINE;

#if(_WIN32_WCE != 200)  //**MARCH99 - no date time control in HPC
#include <afxdtctl.h>
#endif

/////////////////////////////////////////////////////////////////////////////
// CIntrinsicControl
static const FONTDESC _defaultfont = {sizeof(FONTDESC), OLESTR("MS Serif"), FONTSIZE(10), FW_NORMAL, ANSI_CHARSET, false, false, false};

CIntrinsicControl::CIntrinsicControl() : m_Font(&m_xFontNotification), m_nColumns(0), m_bClicking(false)
{
	EnableAutomation();
	// create an IUnknown
	EnableAggregation();

	// allow event connections
	EnableConnections();

	// turn on type library support
	EnableTypeLib();

	m_pioThis=0;
	m_dwExStyle=0;
	m_bProcessingChange=0; //**MARCH99 track change level
	m_bProcessingSelChange=0; //**MARCH99 track change level

	m_ForeColor=RGB(0,0,0);
	m_BackColor=RGB(255,255,255);
	m_hbrushBackground=CreateSolidBrush(m_BackColor);
	//m_lTag=0; //**JULY99
	m_cstrTag.Empty(); //**JULY99
}

CIntrinsicControl::~CIntrinsicControl()
{
	DeleteObject(m_hbrushBackground);
}

void CIntrinsicControl::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CWnd::OnFinalRelease();
}

//	this code associates our type library with our class
IMPLEMENT_OLETYPELIB(CIntrinsicControl, LIBID_Script, 1, 0)

// here's a root event map for the stub (CEventStub)
const AFX_EVENTMAP CIntrinsicEventStub::eventMap = { NULL, NULL };

// here's the document's event map (managed by the Class Wizard)
BEGIN_EVENT_MAP(CIntrinsicControl, CIntrinsicEventStub)
	//{{AFX_EVENT_MAP(CIntrinsicControl)
	//}}AFX_EVENT_MAP
END_EVENT_MAP()

// here's our connection map.  We support one set of events
BEGIN_CONNECTION_MAP(CIntrinsicControl, CWnd)
	CONNECTION_PART(CIntrinsicControl, DIID_DIntrinsicEvents, EventConnPt)
END_CONNECTION_MAP()


//*****************************************************
//** IMPLEMENTATION of IPropertyNotifySink
//*****************************************************
STDMETHODIMP_(ULONG) CIntrinsicControl::XFontNotification::AddRef( )
{
    METHOD_MANAGE_STATE(CIntrinsicControl, FontNotification)
    return 1;
}
STDMETHODIMP_(ULONG) CIntrinsicControl::XFontNotification::Release( )
{
    METHOD_MANAGE_STATE(CIntrinsicControl, FontNotification)
    return 0;
}

STDMETHODIMP CIntrinsicControl::XFontNotification::QueryInterface( REFIID iid, LPVOID FAR* ppvObj )
{
    METHOD_MANAGE_STATE( CIntrinsicControl, FontNotification )
    if( IsEqualIID( iid, IID_IUnknown ) || 
        IsEqualIID( iid, IID_IPropertyNotifySink))
    {
     *ppvObj= this;
     AddRef( );
     return NOERROR;
    }
    return ResultFromScode(E_NOINTERFACE);
}

STDMETHODIMP CIntrinsicControl::XFontNotification::OnChanged(DISPID)
{
	METHOD_PROLOGUE(CIntrinsicControl, FontNotification)
    //METHOD_MANAGE_STATE( CIntrinsicControl, FontNotification )
	//do whatever we have to do to modify the font of the underlying control..

	//pThis->SetFont(pThis->m_Font.GetFontHandle());
	HFONT hfontNew=pThis->m_Font.GetFontHandle();
	//HFONT hfontOld=(HFONT)pThis->SendMessage(WM_GETFONT,0,0);
	
	pThis->SendMessage(WM_SETFONT,(WPARAM)hfontNew,MAKELPARAM(true, 0)    );
	
	/*if(hfontOld!=hfontNew)
		DeleteObject(hfontOld);
	*/

	//pThis->RedrawWindow(0,0,RDW_INVALIDATE|RDW_UPDATENOW);
	//pThis->SetFont(CFont::FromHandle(pThis->m_Font.GetFontHandle()),true);
	return NOERROR;
}

STDMETHODIMP CIntrinsicControl::XFontNotification::OnRequestEdit(DISPID)
{
    return NOERROR;
}

//============================================================
//
//	ole event code dispatching - lifted from COleControl
//
//============================================================
//
// this routine fires an event
//
void CIntrinsicControl::FireEventV(DISPID dispid, BYTE* pbParams, va_list argList)
{
	//
	// COleDispatchDriver - client side IDispatch support
	//
	COleDispatchDriver driver;

	//
	// m_xDocEvents is the connection point for the document's
	// events (DIID__DMrs1DocEvents)
	//
	const CPtrArray* pConnections = m_xEventConnPt.GetConnections();
	ASSERT(pConnections != NULL);

	int i;
	int cConnections = pConnections->GetSize();
	LPDISPATCH pDispatch;
	//
	// loop through all the connections, calling their event handler
	//
	for (i = 0; i < cConnections; i++)
	{
		pDispatch = (LPDISPATCH)(pConnections->GetAt(i));
		ASSERT(pDispatch != NULL);
		driver.AttachDispatch(pDispatch, FALSE);
		TRY
			driver.InvokeHelperV(dispid, DISPATCH_METHOD, VT_EMPTY, NULL,
				pbParams, argList);
		END_TRY
		driver.DetachDispatch();
	}
}

//
// the MFC class wizard generates code that calls this routine for our custom
// events
//
void AFX_CDECL CIntrinsicControl::FireEvent(DISPID dispid, BYTE* pbParams, ...)
{
	va_list argList;
	va_start(argList, pbParams);
	FireEventV(dispid, pbParams, argList);
	va_end(argList);
}

BEGIN_MESSAGE_MAP(CIntrinsicControl, CWnd)
	//{{AFX_MSG_MAP(CIntrinsicControl)
	ON_WM_LBUTTONDOWN()
	ON_WM_ERASEBKGND()
	ON_WM_CTLCOLOR_REFLECT( )
	ON_WM_CREATE()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_SETFOCUS()
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_WM_TIMER()
	ON_WM_KILLFOCUS()
	ON_WM_CHAR()
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	//}}AFX_MSG_MAP
	ON_CONTROL_REFLECT(EN_CHANGE,OnChange)
	ON_CONTROL_REFLECT(BN_CLICKED,OnClick)
	ON_CONTROL_REFLECT(STN_CLICKED,OnClick)
	ON_CONTROL_REFLECT(CBN_EDITCHANGE,OnChange)
	ON_CONTROL_REFLECT(CBN_SELCHANGE,OnSelChange)
	ON_CONTROL_REFLECT(CBN_DROPDOWN,OnDropDown)
	ON_CONTROL_REFLECT(CBN_SETFOCUS,OnSetFocus)
	//ON_CONTROL_REFLECT(CBN_DBLCLK,OnLButtonDblClk)
#ifndef _POCKET
	ON_CONTROL_REFLECT(BN_DBLCLK,OnLButtonDblClk)
#endif
	//ON_CONTROL_REFLECT(LBN_DBLCLK,OnLButtonDblClk)
	ON_CONTROL_REFLECT(LBN_SELCHANGE,OnSelChange)
	ON_NOTIFY_REFLECT(DTN_DATETIMECHANGE,OnNotifyChange)
	ON_NOTIFY_REFLECT(DTN_DROPDOWN,OnNotifyDropDown)
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CIntrinsicControl, CWnd)
	//{{AFX_DISPATCH_MAP(CIntrinsicControl)
	DISP_PROPERTY_EX(CIntrinsicControl, "Left", GetLeft, SetLeft, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "Right", GetRight, SetRight, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "Top", GetTop, SetTop, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "Bottom", GetBottom, SetBottom, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "Width", GetWidth, SetWidth, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "Height", GetHeight, SetHeight, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "Visible", GetVisible, SetVisible, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "TabStop", GetTabStop, SetTabStop, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "Value", GetValue, SetValue, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "MultiLine", GetMultiLine, SetMultiLine, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "Alignment", GetAlignment, SetAlignment, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "MaxLength", GetMaxLength, SetMaxLength, VT_I4)
	DISP_PROPERTY_EX(CIntrinsicControl, "FontName", GetFontName, SetFontName, VT_BSTR)
	DISP_PROPERTY_EX(CIntrinsicControl, "FontSize", GetFontSize, SetFontSize, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "FontBold", GetFontBold, SetFontBold, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "FontItalic", GetFontItalic, SetFontItalic, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "FontUnderline", GetFontUnderline, SetFontUnderline, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "FontStrikethru", GetFontStrikethru, SetFontStrikethru, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "FontWeight", GetFontWeight, SetFontWeight, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "NewIndex", GetNewIndex, SetNewIndex, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "Sorted", GetSorted, SetSorted, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "ScrollBars", GetScrollBars, SetScrollBars, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "Columns", GetColumns, SetColumns, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "ListIndex", GetListIndex, SetListIndex, VT_I4)
	DISP_PROPERTY_EX(CIntrinsicControl, "IntegralHeight", GetIntegralHeight, SetIntegralHeight, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "Style", GetStyle, SetStyle, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "ListCount", GetListCount, SetListCount, VT_I4)
	DISP_PROPERTY_EX(CIntrinsicControl, "LineCount", GetLineCount, SetLineCount, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "Modified", GetModified, SetModified, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "SelStart", GetSelStart, SetSelStart, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "SelLength", GetSelLength, SetSelLength, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "SelText", GetSelText, SetSelText, VT_BSTR)
	DISP_PROPERTY_EX(CIntrinsicControl, "longFormat", GetLongFormat, SetLongFormat, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "minDate", GetMinDate, SetMinDate, VT_DATE)
	DISP_PROPERTY_EX(CIntrinsicControl, "maxDate", GetMaxDate, SetMaxDate, VT_DATE)
	DISP_PROPERTY_EX(CIntrinsicControl, "Date", GetDate, SetDate, VT_DATE)
	DISP_PROPERTY_EX(CIntrinsicControl, "BorderStyle", GetBorderStyle, SetBorderStyle, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "hwnd", GetHwnd, SetHwnd, VT_HANDLE)
	DISP_PROPERTY_EX(CIntrinsicControl, "tag", GetTag, SetTag, VT_BSTR)
	DISP_PROPERTY_EX(CIntrinsicControl, "Enabled", GetEnabled, SetEnabled, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "Min", GetMin, SetMin, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "Max", GetMax, SetMax, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "LargeChange", GetLargeChange, SetLargeChange, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "SmallChange", GetSmallChange, SetSmallChange, VT_I2)
	DISP_PROPERTY_EX(CIntrinsicControl, "Group", GetGroup, SetGroup, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "ParentHWnd", GetParentHWnd, SetParentHWnd, VT_HANDLE)
	DISP_PROPERTY_EX(CIntrinsicControl, "Timer", doGetTimer, doSetTimer, VT_I4)
	DISP_PROPERTY_EX(CIntrinsicControl, "Default", GetDefault, SetDefault, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "NumbersOnly", GetNumbersOnly, SetNumbersOnly, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "LowercaseOnly", GetLowercaseOnly, SetLowercaseOnly, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "UppercaseOnly", GetUppercaseOnly, SetUppercaseOnly, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "Locked", GetLocked, SetLocked, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "MultiSelect", GetMultiSelect, SetMultiSelect, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "Password", GetPassword, SetPassword, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "Redraw", GetRedraw, SetRedraw, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "SelCount", GetSelCount, SetNotSupported, VT_I4)
	DISP_PROPERTY_EX(CIntrinsicControl, "TopIndex", GetTopIndex, SetTopIndex, VT_I4)
	DISP_PROPERTY_EX(CIntrinsicControl, "UseMnemonic", GetUseMnemonic, SetUseMnemonic, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "HideSelection", GetHideSelection, SetHideSelection, VT_BOOL)
	DISP_PROPERTY_EX(CIntrinsicControl, "SpinBox", GetNotSupported, SetSpinBox, VT_BOOL)
	DISP_FUNCTION(CIntrinsicControl, "move", move, VT_EMPTY, VTS_VARIANT VTS_VARIANT VTS_VARIANT VTS_VARIANT)
	DISP_FUNCTION(CIntrinsicControl, "Hide", Hide, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CIntrinsicControl, "Show", Show, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CIntrinsicControl, "SetFocus", SetFocus, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CIntrinsicControl, "Reopen", Reopen, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CIntrinsicControl, "AddItem", AddItem, VT_EMPTY, VTS_BSTR VTS_VARIANT)
	DISP_FUNCTION(CIntrinsicControl, "Clear", Clear, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CIntrinsicControl, "Removeitem", Removeitem, VT_EMPTY, VTS_I4)
	DISP_PROPERTY_PARAM(CIntrinsicControl, "List", GetList, SetList, VT_BSTR, VTS_I4)
	DISP_PROPERTY_PARAM(CIntrinsicControl, "WindowLong", doGetWindowLong, doSetWindowLong, VT_I4, VTS_I2)
	DISP_PROPERTY_PARAM(CIntrinsicControl, "ItemData", GetItemData, SetItemData, VT_I4, VTS_I2)
	DISP_PROPERTY_PARAM(CIntrinsicControl, "Selected", GetSelected, SetSelected, VT_BOOL, VTS_I2)
	DISP_PROPERTY_EX_ID(CIntrinsicControl, "Text", DISPID_TEXT, GetText, SetText, VT_BSTR)
	DISP_PROPERTY_EX_ID(CIntrinsicControl, "BackColor", DISPID_BACKCOLOR, GetBackColor, SetBackColor, VT_COLOR)
	DISP_PROPERTY_EX_ID(CIntrinsicControl, "ForeColor", DISPID_FORECOLOR, GetForeColor, SetForeColor, VT_COLOR)
	DISP_PROPERTY_EX_ID(CIntrinsicControl, "Font", DISPID_FONT, GetFont, SetFont, VT_DISPATCH)
	DISP_PROPERTY_EX_ID(CIntrinsicControl, "Caption", DISPID_CAPTION, GetCaption, SetCaption, VT_BSTR)
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_IIntrinsicControl to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {E13F3DD5-4CBD-11D2-892D-0000E73336C3}
static const IID IID_IIntrinsicControl =
{ 0xe13f3dd5, 0x4cbd, 0x11d2, { 0x89, 0x2d, 0x0, 0x0, 0xe7, 0x33, 0x36, 0xc3 } };

BEGIN_INTERFACE_MAP(CIntrinsicControl, CWnd)
	INTERFACE_PART(CIntrinsicControl, IID_IIntrinsicControl, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CIntrinsicControl message handlers

LPCTSTR CIntrinsicControl::BuildMessage(LPCTSTR szMessage,CString &str)
{
	str=m_cstrName;
	str+=TEXT("_");
	str+=szMessage;
	return (LPCTSTR)str;
}

HRESULT CIntrinsicControl::myGetTypeLib(int iLCID,ITypeLib **ppTypeLib)
{
	return GetTypeLib(iLCID,ppTypeLib);
}

BSTR CIntrinsicControl::GetText() 
{
	CString strResult;
	if(m_pioThis->ictType==IntrinsicList)
	{
		CListBox *listbox=(CListBox *)this;
		int iSel=listbox->GetCurSel();
		if(iSel!=LB_ERR)
			listbox->GetText(listbox->GetCurSel(),strResult);
		else
			strResult=TEXT("");
	}
	else if(m_pioThis->ictType==IntrinsicCombo && m_bProcessingSelChange)
	{
		return GetList(GetListIndex()); //**MARCH99 workaround to get correct text when processing selection change
	}
	else
		GetWindowText(strResult);
	return strResult.AllocSysString();
}

void CIntrinsicControl::SetText(LPCTSTR lpszNewValue) 
{
	SetWindowText(lpszNewValue);
	if(m_pioThis->ictType==IntrinsicEdit || m_pioThis->ictType==IntrinsicCombo)
		OnChange();
}

BSTR CIntrinsicControl::GetCaption() 
{
	return GetText();
}

void CIntrinsicControl::SetCaption(LPCTSTR lpszNewValue) 
{
	SetText(lpszNewValue);
}

void CIntrinsicControl::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CString cstrTemp;

	// Switching lines 123 for 4 is a possible fix for buttons not highlighting, 12 are used to preserve gestures
	//SetState( TRUE );
	//SHRecognizeGesture( point );
	Default();
	//CWnd::OnLButtonDown(nFlags, point);

	switch(m_pioThis->ictType)
	{
	case IntrinsicEdit:
		pENGINE->SendScriptMessage(BuildMessage(TEXT("click"),cstrTemp),VT_EMPTY,0,0);
		break;
	default:
		break;
	}
}

BOOL CIntrinsicControl::PreCreateWindow(CREATESTRUCT& cs) 
{
	if(m_dwExStyle)
		cs.dwExStyle|=m_dwExStyle;

	cs.dwExStyle|=WS_EX_NOANIMATION;

	switch(m_pioThis->ictType)
	{
	case IntrinsicList:
		cs.style|=LBS_NOTIFY;
		break;
//#ifndef _WIN32_WCE_EMULATION
		//for some reason, this crashes the emulator.  
	case IntrinsicCombo:
		cs.style|=WS_VSCROLL;
		break;
//#endif
	}
	return CWnd::PreCreateWindow(cs);
}

void CIntrinsicControl::move(const VARIANT FAR& left, const VARIANT FAR& top, const VARIANT FAR& width, const VARIANT FAR& height) 
{
	RECT rectCtl;
	int iCurWidth,iCurHeight;
	int iNewLeft,iNewTop,iNewWidth,iNewHeight;

	doGetAdjustedBounds(this,&rectCtl,0,0,&iCurWidth,&iCurHeight);

	iNewLeft=doExtractIntFromVariant(&left,rectCtl.left);
	iNewTop=doExtractIntFromVariant(&top,rectCtl.top);
	iNewWidth=doExtractIntFromVariant(&width,iCurWidth);
	iNewHeight=doExtractIntFromVariant(&height,iCurHeight);

	MoveWindow(iNewLeft,iNewTop,iNewWidth,iNewHeight,true);
}

short CIntrinsicControl::GetLeft() 
{
	int iLeft;

	doGetAdjustedBounds(this,0,&iLeft);

	return iLeft;
}

void CIntrinsicControl::SetLeft(short nNewValue) 
{
	int iCurWidth,iCurHeight,iCurTop;
	
	doGetAdjustedBounds(this,0,0,&iCurTop,&iCurWidth,&iCurHeight);
	MoveWindow(nNewValue,iCurTop,iCurWidth,iCurHeight,true);
}

short CIntrinsicControl::GetRight() 
{
	RECT rectCtl;

	doGetAdjustedBounds(this,&rectCtl);

	return (short)rectCtl.right;
}

void CIntrinsicControl::SetRight(short nNewValue) 
{
	int iCurLeft,iCurHeight,iCurTop;
	
	doGetAdjustedBounds(this,0,&iCurLeft,&iCurTop,0,&iCurHeight);
	MoveWindow(iCurLeft,iCurTop,max(0,nNewValue-iCurLeft),iCurHeight,true);
}

short CIntrinsicControl::GetTop() 
{
	int iTop;

	doGetAdjustedBounds(this,0,0,&iTop);

	return iTop;
}

void CIntrinsicControl::SetTop(short nNewValue) 
{
	int iCurWidth,iCurHeight,iCurLeft;
	
	doGetAdjustedBounds(this,0,&iCurLeft,0,&iCurWidth,&iCurHeight);
	MoveWindow(iCurLeft,nNewValue,iCurWidth,iCurHeight,true);
}

short CIntrinsicControl::GetBottom() 
{
	RECT rectCtl;

	doGetAdjustedBounds(this,&rectCtl);

	return (short)rectCtl.bottom;
}

void CIntrinsicControl::SetBottom(short nNewValue) 
{
	int iCurLeft,iCurWidth,iCurTop;
	
	doGetAdjustedBounds(this,0,&iCurLeft,&iCurTop,&iCurWidth,0);
	MoveWindow(iCurLeft,iCurTop,iCurWidth,max(0,nNewValue-iCurTop),true);
}

short CIntrinsicControl::GetWidth() 
{
	int iWidth;

	doGetAdjustedBounds(this,0,0,0,&iWidth);

	return iWidth;
}

void CIntrinsicControl::SetWidth(short nNewValue) 
{
	int iCurLeft,iCurHeight,iCurTop;
	
	doGetAdjustedBounds(this,0,&iCurLeft,&iCurTop,0,&iCurHeight);
	MoveWindow(iCurLeft,iCurTop,nNewValue,iCurHeight,true);
}

short CIntrinsicControl::GetHeight() 
{
	int iHeight;

	doGetAdjustedBounds(this,0,0,0,0,&iHeight);

	return iHeight;
}

void CIntrinsicControl::SetHeight(short nNewValue) 
{
	int iCurLeft,iCurWidth,iCurTop;
	
	doGetAdjustedBounds(this,0,&iCurLeft,&iCurTop,&iCurWidth,0);
	MoveWindow(iCurLeft,iCurTop,iCurWidth,nNewValue,true);
}

BOOL CIntrinsicControl::GetVisible() 
{
	return IsWindowVisible();
}

void CIntrinsicControl::SetVisible(BOOL bNewValue) 
{
	ShowWindow(bNewValue?SW_SHOW:SW_HIDE);
}

void CIntrinsicControl::Hide() 
{
	ShowWindow(SW_HIDE);
}

void CIntrinsicControl::Show() 
{
	ShowWindow(SW_SHOW);
}

BOOL CIntrinsicControl::GetTabStop() 
{
	DWORD dwStyle = GetWindowLong(m_hWnd,GWL_STYLE);

	return (dwStyle&WS_TABSTOP)?true:false;
}

void CIntrinsicControl::SetTabStop(BOOL bNewValue) 
{
	DWORD dwStyle = GetWindowLong(m_hWnd,GWL_STYLE);

	if (bNewValue)
		dwStyle|=WS_TABSTOP;
	else
		dwStyle&=~WS_TABSTOP;
	SetWindowLong(m_hWnd,GWL_STYLE,dwStyle);
}

void CIntrinsicControl::SetFocus() 
{
	CWnd *cwndOld = GetFocus();
	CWnd::SetFocus();
	//**MARCH99 manually sending this
	//OnSetFocus(cwndOld);
}

short CIntrinsicControl::GetValue() 
{
	switch(m_pioThis->ictType)
	{
	case IntrinsicCheck:
	case IntrinsicTriButton:
		return ((CButton *) this)->GetCheck();
		break;
	case IntrinsicRadio:
		{
			int iVal=((CButton *) this)->GetCheck();
			if(iVal)
				return -1;
			else
				return 0;
			break;
		}
	case IntrinsicHScrollBar:
	case IntrinsicVScrollBar:
		return ((CScrollBar *) this)->GetScrollPos();
		break;
	default: //commandbutton, etc.
		return 0;
	}
}

void CIntrinsicControl::SetValue(short nNewValue) 
{
	CString cstrTemp;

	switch(m_pioThis->ictType)
	{
	case IntrinsicCheck:
		((CButton *) this)->SetCheck(nNewValue);
		//PostMessage(BM_CLICK,0,0);		
		pENGINE->SendScriptMessage(BuildMessage(TEXT("click"),cstrTemp),VT_EMPTY,0,0);
		break;
	case IntrinsicRadio:
		{//radio buttons use true and false..
			if(nNewValue)
			{
				((CButton *) this)->SetCheck(1);
				// PostMessage(BM_CLICK,0,0);
				if (!m_bClicking)
				{
					m_bClicking = true;
					pENGINE->SendScriptMessage(BuildMessage(TEXT("click"),cstrTemp),VT_EMPTY,0,0);
					m_bClicking = false;
				}
			}
			else
				((CButton *) this)->SetCheck(0);
			break;
		}
	case IntrinsicButton:
		{
			//CString cstrTemp;
			if(nNewValue)
				PostMessage(BM_CLICK,0,0);
			//pENGINE->SendScriptMessage(BuildMessage(TEXT("click"),cstrTemp),VT_EMPTY,0,0);
			break;
		}
	case IntrinsicTriButton:
		{
			((CButton *) this)->SetCheck( nNewValue );
			pENGINE->SendScriptMessage(BuildMessage(TEXT("click"),cstrTemp),VT_EMPTY,0,0);
			break;
		}
	case IntrinsicHScrollBar:
	case IntrinsicVScrollBar:
		{
			((CScrollBar *) this)->SetScrollPos( nNewValue );
			pENGINE->SendScriptMessage( BuildMessage( _T("click"), cstrTemp ), VT_EMPTY, 0, 0 );
			break;
		}
	default:
		break;
	}
}

BOOL CIntrinsicControl::GetMultiLine() 
{
	DWORD dwStyle;

	if (m_pioThis->ictType!=IntrinsicEdit)
	{
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return false;
	}

	dwStyle=GetWindowLong(m_hWnd,GWL_STYLE);

	return (dwStyle&ES_MULTILINE)?true:false;
}

void CIntrinsicControl::SetMultiLine(BOOL bNewValue) 
{
	DWORD dwStyle;

	if (m_pioThis->ictType!=IntrinsicEdit)
	{
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return;
	}

	dwStyle=GetWindowLong(m_hWnd,GWL_STYLE);

	if (bNewValue)
		dwStyle|=ES_MULTILINE|ES_AUTOVSCROLL|ES_WANTRETURN;
	else
	{
		dwStyle&=~ES_AUTOVSCROLL;
		dwStyle&=~ES_MULTILINE;
		dwStyle&=~ES_WANTRETURN;
	}

	SetWindowLong(m_hWnd,GWL_STYLE,dwStyle);
	Reopen();
}

OLE_COLOR CIntrinsicControl::GetBackColor() 
{
	return m_BackColor;
}

void CIntrinsicControl::SetBackColor(OLE_COLOR nNewValue) 
{
	//m_BackColor=COleControl::TranslateColor(nNewValue,0);
	//_AfxOleTranslateColor(nNewValue, 0, &m_BackColor);
	//m_BackColor=COleControl::TranslateColor(nNewValue,0);
	//TranslateColor just casts to a COLORREF

	//MessageBox(0,TEXT("Setting background color"),MB_OK);

	DeleteObject(m_hbrushBackground);
	// Added to handle System Palette colors
	if( nNewValue > 0xFFFFFF )
	{
		m_hbrushBackground = GetSysColorBrush( nNewValue & 0xFF );
		CBrush *pb = CBrush::FromHandle(m_hbrushBackground);
		LOGBRUSH lb;
		pb->GetLogBrush( &lb );
		m_BackColor = lb.lbColor;
		RedrawWindow(0,0,RDW_INVALIDATE|RDW_UPDATENOW);
	}
	else
	{
		m_BackColor = (COLORREF)nNewValue;
		m_hbrushBackground=CreateSolidBrush(m_BackColor);
		RedrawWindow(0,0,RDW_INVALIDATE|RDW_UPDATENOW);
	}
}

OLE_COLOR CIntrinsicControl::GetForeColor() 
{
	return m_ForeColor;
}

void CIntrinsicControl::SetForeColor(OLE_COLOR nNewValue) 
{
	if( nNewValue > 0xFFFFFF )
	{
		HBRUSH hb = GetSysColorBrush( nNewValue & 0xFF );
		CBrush *pb = CBrush::FromHandle( hb );
		LOGBRUSH lb;
		pb->GetLogBrush( &lb );
		m_ForeColor = lb.lbColor;
	}
	else
		m_ForeColor=(COLORREF)nNewValue;
	RedrawWindow(0,0,RDW_INVALIDATE|RDW_UPDATENOW);
}

BOOL CIntrinsicControl::OnEraseBkgnd(CDC* pDC) 
{
	CRect rectMe;

	GetClientRect(&rectMe);
	
	pDC->FillSolidRect(&rectMe,m_BackColor);
	return true;
	//return CWnd::OnEraseBkgnd(pDC);
}

HBRUSH CIntrinsicControl::CtlColor ( CDC* pDC, UINT nCtlColor )
{
	switch(nCtlColor)
	{
	case CTLCOLOR_BTN:
		pDC->SetBkColor(m_BackColor);
		pDC->SetTextColor(m_ForeColor); //text color controls focus rect, not text for button
		break;
	default:
		pDC->SetBkColor(m_BackColor);
		pDC->SetTextColor(m_ForeColor);
	}
	return m_hbrushBackground;
}

short CIntrinsicControl::GetAlignment() 
{
	short retval;
	DWORD dwStyle = GetWindowLong(m_hWnd,GWL_STYLE);

	switch(m_pioThis->ictType)
	{
	case IntrinsicEdit:
		if(dwStyle&ES_CENTER)
			retval=2;
		else if (dwStyle&ES_RIGHT)
			retval=1;
		else
			retval=0;
		break;
	case IntrinsicStatic:
		if(dwStyle&SS_CENTER)
			retval=2;
		else if (dwStyle&SS_RIGHT)
			retval=1;
		else
			retval=0;
		break;
	default:
		if(dwStyle&BS_LEFTTEXT)
			retval=1;
		else
			retval=0;
		break;
	}
	return retval; 
}

void CIntrinsicControl::SetAlignment(short nNewValue) 
{
	DWORD dwStyle = GetWindowLong(m_hWnd,GWL_STYLE);

	switch(m_pioThis->ictType)
	{
	case IntrinsicEdit:
		dwStyle&=~ES_LEFT;
		dwStyle&=~ES_CENTER;
		dwStyle&=~ES_RIGHT;
		if(nNewValue==2)
			dwStyle|=ES_CENTER;
		else if (nNewValue==1)
			dwStyle|=ES_RIGHT;
		else
			dwStyle|=ES_LEFT;
		break;
	case IntrinsicStatic:
		dwStyle&=~SS_LEFT;
		dwStyle&=~SS_CENTER;
		dwStyle&=~SS_RIGHT;
		if(nNewValue==2)
			dwStyle|=SS_CENTER;
		else if (nNewValue==1)
			dwStyle|=SS_RIGHT;
		else
			dwStyle|=SS_LEFT;
		break;
	case IntrinsicCheck:
	case IntrinsicRadio:
		if(nNewValue==1)
			dwStyle|=BS_RIGHTBUTTON;
		else
			dwStyle&=~BS_RIGHTBUTTON;
		break;
	default: return;
	}
	SetWindowLong(m_hWnd,GWL_STYLE,dwStyle);

	if(m_pioThis->ictType==IntrinsicEdit)
		Reopen();
	else
	{
		ShowWindow(SW_HIDE);
		ShowWindow(SW_SHOW);
	}
}

#define vbScrollNone 0
#define vbScrollHorizontal 1
#define vbScrollVertical 2
#define vbScrollBoth 3

short CIntrinsicControl::GetScrollBars() 
{
	DWORD dwStyle = GetWindowLong(m_hWnd,GWL_STYLE);

	if (m_pioThis->ictType!=IntrinsicEdit && m_pioThis->ictType!=IntrinsicList)
	{
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return vbScrollNone;
	}
	if(dwStyle&WS_HSCROLL)
	{
		if (dwStyle&WS_VSCROLL)
			return vbScrollBoth;
		else
			return vbScrollHorizontal;
	}
	else if (dwStyle&WS_VSCROLL)
		return vbScrollVertical;
	else
		return vbScrollNone;
}

void CIntrinsicControl::SetScrollBars(short nNewValue) 
{
	DWORD dwStyle = GetWindowLong(m_hWnd,GWL_STYLE);

	if (m_pioThis->ictType!=IntrinsicEdit && m_pioThis->ictType!=IntrinsicList)
	{
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return;
	}

	dwStyle&=~WS_HSCROLL;
	dwStyle&=~WS_VSCROLL;

	switch(nNewValue)
	{
	case vbScrollHorizontal:
		dwStyle|=WS_HSCROLL;
		break;
	case vbScrollVertical:
		dwStyle|=WS_VSCROLL;
		break;
	case vbScrollBoth:
		dwStyle|=WS_HSCROLL|WS_VSCROLL;
		break;
	}

	SetWindowLong(m_hWnd,GWL_STYLE,dwStyle);

	Reopen();
}

void CIntrinsicControl::SetColumns(short nNewValue) 
{
	DWORD dwStyle = GetWindowLong(m_hWnd,GWL_STYLE);

	if (m_pioThis->ictType!=IntrinsicList)
	{
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return;
	}

	m_nColumns = nNewValue;

	boolean isMulti = (dwStyle & LBS_MULTICOLUMN) ? true : false;

	dwStyle&=~LBS_MULTICOLUMN;

	if (nNewValue) dwStyle |= LBS_MULTICOLUMN;
	SetWindowLong(m_hWnd,GWL_STYLE,dwStyle);

	Reopen();
}

short CIntrinsicControl::GetColumns() 
{
	DWORD dwStyle = GetWindowLong(m_hWnd,GWL_STYLE);

	if (m_pioThis->ictType==IntrinsicList)
	{
		return m_nColumns;
	}
	else
	{
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return vbScrollNone;
	}
}

BOOL CIntrinsicControl::GetSorted() 
{
	BOOL retval=false;
	DWORD dwStyle = GetWindowLong(m_hWnd,GWL_STYLE);

	switch(m_pioThis->ictType)
	{
	case IntrinsicList:
		if(dwStyle&LBS_SORT)
			retval=true;
		break;
	case IntrinsicCombo:
		if(dwStyle&CBS_SORT)
			retval=true;
	}
	return retval; 
}

void CIntrinsicControl::SetSorted(BOOL bNewValue) 
{
	DWORD dwStyle = GetWindowLong(m_hWnd,GWL_STYLE);

	switch(m_pioThis->ictType)
	{
	case IntrinsicList:
		if(bNewValue)
			dwStyle|=LBS_SORT;
		else
			dwStyle&=~LBS_SORT;
		break;
	case IntrinsicCombo:
		if(bNewValue)
			dwStyle|=CBS_SORT;
		else
			dwStyle&=~CBS_SORT;
		break;
	}
	SetWindowLong(m_hWnd,GWL_STYLE,dwStyle);
	Reopen();
}

void CIntrinsicControl::Reopen() 
{
	DWORD dwStyle, dwExStyle, dwID;
	CString cstrText;
	DWORD dwStart,dwEnd, dwLimit;
	HWND hwndParent;
	RECT rectWnd,rectParent;
	HFONT hfontOld;
	long lHeightAdd=0;
	hwndParent=::GetParent(m_hWnd);

	++m_bReopening;

	//special-case code for different intrinsic types
	switch(m_pioThis->ictType)
	{
	case IntrinsicEdit:
		SendMessage(EM_GETSEL,(WPARAM)&dwStart,(LPARAM)&dwEnd);
		dwLimit=SendMessage(EM_GETLIMITTEXT,0,0);
		break;
	case IntrinsicCombo:
		{
			RECT rectCtl;

			SendMessage(CB_GETDROPPEDCONTROLRECT,0,(LPARAM)&rectCtl);
			lHeightAdd=rectCtl.bottom-rectCtl.top;
			break;
		}
	}
	
	hfontOld=(HFONT)SendMessage(WM_GETFONT,0,0);
	GetWindowText(cstrText);

	//get the rect, relative to our parent
	GetWindowRect(&rectWnd);
	GetParent()->GetWindowRect(&rectParent);
	OffsetRect(&rectWnd,-rectParent.left,-rectParent.top);
	rectWnd.bottom+=lHeightAdd;

	//get the window long values
	dwExStyle=GetWindowLong(m_hWnd,GWL_EXSTYLE);
	dwID=GetWindowLong(m_hWnd,GWL_ID);
	dwStyle=GetWindowLong(m_hWnd,GWL_STYLE);

	//Destroy and re-create the window
	DestroyWindow();
	CreateEx(dwExStyle,m_pioThis->szClass,cstrText,dwStyle,rectWnd.left,rectWnd.top,rectWnd.right-rectWnd.left,rectWnd.bottom-rectWnd.top,hwndParent,(HMENU)dwID,0);

	//EMP necessary to maintain scrolling
	SetWindowLong(m_hWnd,GWL_STYLE,dwStyle);

	//Bring the window to the top of the Z-Order
	//might be able to modify this in the future to try to retain Z-ordering
	BringWindowToTop();

	SendMessage(WM_SETFONT,(WPARAM)hfontOld,MAKELPARAM(true, 0));
	//special-case code for different intrinsic types
	switch(m_pioThis->ictType)
	{
	case IntrinsicEdit:
		SendMessage(EM_SETSEL,dwStart,dwEnd);
		SendMessage(EM_SETLIMITTEXT,dwLimit,0);
		break;

	case IntrinsicList:
		if (m_nColumns)
		{
			RECT rect;
			GetClientRect(&rect);

			SendMessage(LB_SETCOLUMNWIDTH, (rect.right - rect.left) / m_nColumns, 0);
		}
		break;
	}
	SetWindowText(cstrText);

	--m_bReopening;
}

LPDISPATCH CIntrinsicControl::GetFont() 
{
	return m_Font.GetIDispatch(true);
}

void CIntrinsicControl::SetFont(LPDISPATCH newValue) 
{
}


int CIntrinsicControl::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	m_Font.InitializeFont(&_defaultfont,NULL);
	switch( m_pioThis->ictType )
	{
	case IntrinsicHScrollBar:
	case IntrinsicVScrollBar:
		SetLargeChange( 10 );
		m_nSmallScroll = 1;
		break;
	}

	return 0;
}

long CIntrinsicControl::GetMaxLength() 
{
	if(m_pioThis->ictType != IntrinsicEdit)
		return 0;
	return SendMessage(EM_GETLIMITTEXT,0,0);
}

void CIntrinsicControl::SetMaxLength(long nNewValue) 
{
	if(m_pioThis->ictType != IntrinsicEdit)
		return;

	if(GetMultiLine())
		nNewValue=min(nNewValue,65535);
	else
		nNewValue=min(nNewValue,32766);
	SendMessage(EM_SETLIMITTEXT,nNewValue,0);
}

BSTR CIntrinsicControl::GetFontName() 
{
	return m_Font.GetName();
}

void CIntrinsicControl::SetFontName(LPCTSTR lpszNewValue) 
{
	m_Font.SetName(lpszNewValue);
}

long CIntrinsicControl::GetFontSize() 
{
	return m_Font.GetSize();
}

void CIntrinsicControl::SetFontSize(long nNewValue) 
{
	m_Font.SetSize(nNewValue);
}

BOOL CIntrinsicControl::GetFontBold() 
{
	return m_Font.GetBold();
}

void CIntrinsicControl::SetFontBold(BOOL bNewValue) 
{
	m_Font.SetBold(bNewValue);
}

BOOL CIntrinsicControl::GetFontItalic() 
{
	return m_Font.GetItalic();
}

void CIntrinsicControl::SetFontItalic(BOOL bNewValue) 
{
	m_Font.SetItalic(bNewValue);
}

BOOL CIntrinsicControl::GetFontUnderline() 
{
	return m_Font.GetUnderline();
}

void CIntrinsicControl::SetFontUnderline(BOOL bNewValue) 
{
	m_Font.SetUnderline(bNewValue);
}

BOOL CIntrinsicControl::GetFontStrikethru() 
{
	return m_Font.GetStrikethrough();
}

void CIntrinsicControl::SetFontStrikethru(BOOL bNewValue) 
{
	m_Font.SetStrikethrough(bNewValue);
}

short CIntrinsicControl::GetFontWeight() 
{
	return m_Font.GetWeight();	
}

void CIntrinsicControl::SetFontWeight(short nNewValue) 
{
	m_Font.SetWeight(nNewValue);
}

void CIntrinsicControl::AddItem(LPCTSTR item, const VARIANT FAR& vIndex) 
{
	DWORD retval;
	DWORD dwMessage=0;
	int iIndex = doExtractIntFromVariant(&vIndex,-1);

	if (m_pioThis->ictType!=IntrinsicList && m_pioThis->ictType!=IntrinsicCombo)
	{
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return;
	}

	if(iIndex==-1)
	{//add with no index
		if(m_pioThis->ictType==IntrinsicList)
			retval=SendMessage(LB_ADDSTRING,0,(LPARAM)item);
		else
			retval=SendMessage(CB_ADDSTRING,0,(LPARAM)item);

	}
	else
	{
		if(m_pioThis->ictType==IntrinsicList)
			retval=SendMessage(LB_INSERTSTRING,iIndex,(LPARAM)item);
		else
			retval=SendMessage(CB_INSERTSTRING,iIndex,(LPARAM)item);
	}

	switch(retval)
	{
		case LB_ERR:
		{
			AfxThrowOleDispatchException(kEXCEPTION_CONTROLERR,IDS_EXCEPTION_CONTROLERR);
			break;
		}
		case LB_ERRSPACE:
		{
			AfxThrowOleDispatchException(kEXCEPTION_NOMEMORY,IDS_EXCEPTION_NOMEMORY);
			break;
		}
		default:
			m_NewIndex=retval;
			break;
	}
}

short CIntrinsicControl::GetNewIndex() 
{
	return m_NewIndex;
}

void CIntrinsicControl::SetNewIndex(short nNewValue) 
{
	AfxThrowOleDispatchException(kEXCEPTION_READONLY,IDS_EXCEPTION_READONLY);
}

void CIntrinsicControl::OnClick(void)
{
	OSVERSIONINFO versionInfo;
	versionInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	if (!GetVersionEx(&versionInfo))
	{
		versionInfo.dwMajorVersion = 2;
	}

	if (versionInfo.dwMajorVersion >= 5 && IntrinsicRadio == m_pioThis->ictType)
	{
		SetValue(GetValue() ? 0 : 1);	// EMP made radio buttons manual for Mobile 5
		if (!GetValue())
		{
			CString cstrTemp;
			pENGINE->SendScriptMessage(BuildMessage(TEXT("click"),cstrTemp),VT_EMPTY,0,0);
		}
	}
	else
	{
		CString cstrTemp;

		pENGINE->SendScriptMessage(BuildMessage(TEXT("click"),cstrTemp),VT_EMPTY,0,0);

	}
}

void CIntrinsicControl::OnChange()
{
	CString cstrTemp;

	//if (!m_bProcessingChange)
	//{
		m_bProcessingChange++;
		pENGINE->SendScriptMessage(BuildMessage(TEXT("change"),cstrTemp),VT_EMPTY,0,0);
		m_bProcessingChange--;
	//}
}

afx_msg void CIntrinsicControl::OnNotifyChange( NMHDR * pNotifyStruct, LRESULT * result )
{
	if(m_pioThis->ictType==IntrinsicDate)
	{
#if(_WIN32_WCE != 200)  //**MARCH99 - no Date/Time control in HPC
		static 	COleDateTime dtLast,dt;
		((CDateTimeCtrl *)this)->GetTime(dt);
		if(dt!=dtLast)
			OnChange();
		dtLast=dt;
#endif
	}
	else
		OnChange();
	*result=false;
}


void CIntrinsicControl::OnSelChange()
{
	CString cstrTemp;

	//pENGINE->SendScriptMessage(BuildMessage(TEXT("change"),cstrTemp),VT_EMPTY,0,0);
	m_bProcessingSelChange++;
	pENGINE->SendScriptMessage(BuildMessage(TEXT("click"),cstrTemp),VT_EMPTY,0,0);
	m_bProcessingSelChange--;
}

void CIntrinsicControl::OnDropDown()
{
	CString cstrTemp;

	pENGINE->SendScriptMessage(BuildMessage(TEXT("DropDown"),cstrTemp),VT_EMPTY,0,0);
}

afx_msg void CIntrinsicControl::OnNotifyDropDown( NMHDR * pNotifyStruct, LRESULT * result )
{
	OnDropDown();
	*result=false;
}

void CIntrinsicControl::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	CString cstrTemp;

	CWnd::OnLButtonDblClk(nFlags, point);
	pENGINE->SendScriptMessage(BuildMessage(TEXT("DblClick"),cstrTemp),VT_EMPTY,0,0);
}

void CIntrinsicControl::Clear() 
{
	DWORD dwMessage;

	switch(m_pioThis->ictType)
	{
	case IntrinsicCombo:
		dwMessage=CB_RESETCONTENT;
		break;
	case IntrinsicList:
		dwMessage=LB_RESETCONTENT;
		break;
	default:
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return;
	}
	SendMessage(dwMessage,0,0);
}

void CIntrinsicControl::Removeitem(long lIndex) 
{
	DWORD dwMessage;

	switch(m_pioThis->ictType)
	{
	case IntrinsicCombo:
		dwMessage=CB_DELETESTRING;
		break;
	case IntrinsicList:
		dwMessage=LB_DELETESTRING;
		break;
	default:
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return;
	}
	SendMessage(dwMessage,lIndex,0);
}

long CIntrinsicControl::GetListIndex() 
{
	DWORD dwMessage;
	long lRetval;

	switch(m_pioThis->ictType)
	{
	case IntrinsicCombo:
		dwMessage=CB_GETCURSEL;
		break;
	case IntrinsicList:
		dwMessage=LB_GETCURSEL;
		break;
	default:
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return -1;
	}
	lRetval=SendMessage(dwMessage,0,0);

	if(lRetval==LB_ERR || lRetval==CB_ERR)
		return -1; //no selection
	else
		return lRetval;
}

void CIntrinsicControl::SetListIndex(long lIndex) 
{
	DWORD dwMessage;

	switch(m_pioThis->ictType)
	{
	case IntrinsicCombo:
		dwMessage=CB_SETCURSEL;
		break;
	case IntrinsicList:
		dwMessage=LB_SETCURSEL;
		break;
	default:
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return;
	}
	SendMessage(dwMessage,lIndex,0);
}

BOOL CIntrinsicControl::GetIntegralHeight() 
{
	DWORD dwStyleFlag,dwStyle;

	dwStyle=GetWindowLong(m_hWnd,GWL_STYLE);

	switch(m_pioThis->ictType)
	{
	case IntrinsicCombo:
		dwStyleFlag=CBS_NOINTEGRALHEIGHT;
		break;
	case IntrinsicList:
		dwStyleFlag=LBS_NOINTEGRALHEIGHT;
		break;
	default:
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return -1;
	}
	return (dwStyle&dwStyleFlag)?false:true;
}

void CIntrinsicControl::SetIntegralHeight(BOOL bNewValue) 
{
	DWORD dwStyleFlag,dwStyle;
	BOOL bCurVal;

	dwStyle=GetWindowLong(m_hWnd,GWL_STYLE);
	switch(m_pioThis->ictType)
	{
	case IntrinsicCombo:
		dwStyleFlag=CBS_NOINTEGRALHEIGHT;
		break;
	case IntrinsicList:
		dwStyleFlag=LBS_NOINTEGRALHEIGHT;
		break;
	default:
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return;
	}
	bCurVal=(dwStyle&dwStyleFlag)?false:true;;
	if(bCurVal!=bNewValue)
	{
		dwStyle&=~dwStyleFlag;
		if(!bNewValue)  //the flag is the reverse of the property
			dwStyle|=dwStyleFlag;
		SetWindowLong(m_hWnd,GWL_STYLE,dwStyle);
		Reopen();
	}
}

#define vbComboDropDown 0
#define vbComboSimple 1
#define vbComboDropDownList 2

short CIntrinsicControl::GetStyle() 
{
	DWORD dwStyle;

	if(m_pioThis->ictType!=IntrinsicCombo)
	{
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return 0;
	}
	dwStyle=GetWindowLong(m_hWnd,GWL_STYLE);
	if(dwStyle&CBS_DROPDOWNLIST == CBS_DROPDOWNLIST)
		return vbComboDropDownList;
	else
		return vbComboDropDown;
}

void CIntrinsicControl::SetStyle(short nNewValue) 
{
	DWORD dwStyle;
	dwStyle=GetWindowLong(m_hWnd,GWL_STYLE);

	if(m_pioThis->ictType!=IntrinsicCombo)
	{
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return;
	}

	//dwStyle&=~CBS_SIMPLE;
	dwStyle&=~CBS_DROPDOWN;
	dwStyle&=~CBS_DROPDOWNLIST;

	switch(nNewValue)
	{
	case vbComboSimple:
		//dwStyle|=CBS_SIMPLE;
		//break;
	case vbComboDropDown:
		dwStyle|=CBS_DROPDOWN;
		break;
	case vbComboDropDownList:
		dwStyle|=CBS_DROPDOWNLIST;
		break;
	}
	SetWindowLong(m_hWnd,GWL_STYLE,dwStyle);

	Reopen();
}

long CIntrinsicControl::GetListCount() 
{
	DWORD dwMessage;
	long lRetval;

	switch(m_pioThis->ictType)
	{
	case IntrinsicCombo:
		dwMessage=CB_GETCOUNT;
		break;
	case IntrinsicList:
		dwMessage=LB_GETCOUNT;
		break;
	default:
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return -1;
	}
	lRetval=SendMessage(dwMessage,0,0);

	return lRetval;
}

void CIntrinsicControl::SetListCount(long nNewValue) 
{
	AfxThrowOleDispatchException(kEXCEPTION_READONLY,IDS_EXCEPTION_READONLY);
}

BSTR CIntrinsicControl::GetList(long iIndex) 
{
	CString strResult;
	DWORD dwMessage, dwLenMessage;
	long lLen;
	TCHAR *szBuf;

	switch(m_pioThis->ictType)
	{
	case IntrinsicCombo:
		dwLenMessage=CB_GETLBTEXTLEN;
		dwMessage=CB_GETLBTEXT;
		break;
	case IntrinsicList:
		dwLenMessage=LB_GETTEXTLEN;
		dwMessage=LB_GETTEXT;
		break;
	default:
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		strResult=TEXT("");
		return strResult.AllocSysString();
	}
	lLen=SendMessage(dwLenMessage,(WPARAM)iIndex,0);
	if(lLen==LB_ERR || lLen==CB_ERR)
		AfxThrowOleDispatchException(kEXCEPTION_OUTOFBOUNDS,IDS_EXCEPTION_OUTOFBOUNDS);

	if(lLen>0)
	{
		szBuf=(TCHAR *)LocalAlloc(LPTR,(lLen+1)*sizeof(TCHAR));
		if(szBuf)
		{
			SendMessage(dwMessage,(WPARAM)iIndex,(LPARAM)szBuf);
			strResult=szBuf;
			LocalFree(szBuf);
		}
		else
			strResult=TEXT("");
	}
	else
		strResult=TEXT("");
	
	return strResult.AllocSysString();
}

void CIntrinsicControl::SetList(long iIndex, LPCTSTR lpszNewValue) 
{
	AfxThrowOleDispatchException(kEXCEPTION_READONLY,IDS_EXCEPTION_READONLY);
}

void CIntrinsicControl::OnSetFocus(CWnd* pOldWnd) 
{
	CString cstrTemp;
		CWnd::OnSetFocus(pOldWnd);
		pENGINE->SendScriptMessage(BuildMessage(TEXT("gotfocus"),cstrTemp),VT_EMPTY,0,0);
}

void CIntrinsicControl::OnKillFocus(CWnd* pNewWnd) 
{
	CString cstrTemp;
	CWnd::OnKillFocus(pNewWnd);
	pENGINE->SendScriptMessage(BuildMessage(TEXT("lostfocus"),cstrTemp),VT_EMPTY,0,0);
}

void CIntrinsicControl::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CWnd::OnChar(nChar, nRepCnt, nFlags);
	CString cstrTemp;
	BYTE parms[] = VTS_I4;
	pENGINE->SendScriptMessage(BuildMessage(TEXT("keypress"),cstrTemp),VT_EMPTY,0,parms,long(nChar));
}

void CIntrinsicControl::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CString cstrTemp;
	BYTE parms[] = VTS_I4 VTS_I4;
	int iShift = 0;

	CWnd::OnKeyDown(nChar, nRepCnt, nFlags);
	
	iShift|=(GetKeyState(VK_SHIFT)&0x80)?0x01:0x00;
	iShift|=(GetKeyState(VK_CONTROL)&0x80)?0x02:0x00;
	iShift|=(GetKeyState(VK_MENU)&0x80)?0x04:0x00;
	pENGINE->SendScriptMessage(BuildMessage(TEXT("keydown"),cstrTemp),VT_EMPTY,0,parms,long(nChar),iShift);
}

void CIntrinsicControl::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CWnd::OnKeyUp(nChar, nRepCnt, nFlags);
	CString cstrTemp;
	BYTE parms[] = VTS_I4 VTS_I4;
	int iShift = 0;
	iShift|=(GetKeyState(VK_SHIFT)&0x80)?0x01:0x00;
	iShift|=(GetKeyState(VK_CONTROL)&0x80)?0x02:0x00;
	iShift|=(GetKeyState(VK_MENU)&0x80)?0x04:0x00;
	pENGINE->SendScriptMessage(BuildMessage(TEXT("keyup"),cstrTemp),VT_EMPTY,0,parms,long(nChar),iShift);
}

short CIntrinsicControl::GetLineCount() 
{//number of lines in a multiline edit control
 //**MARCH99 new
	switch(m_pioThis->ictType)
	{
	case IntrinsicEdit:
		if(GetMultiLine())
			return ((CEdit *)this)->GetLineCount();
		else 
			return 1;
		break;
	default:
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return -1;
	}
}

void CIntrinsicControl::SetLineCount(short nNewValue) 
{//**MARCH99 new
	AfxThrowOleDispatchException(kEXCEPTION_READONLY,IDS_EXCEPTION_READONLY);
}

BOOL CIntrinsicControl::GetModified() 
{//**MARCH99 new
	switch(m_pioThis->ictType)
	{
	case IntrinsicEdit:
		return ((CEdit *)this)->GetModify();
		break;
	default:
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return -1;
	}
}

void CIntrinsicControl::SetModified(BOOL bNewValue) 
{//**MARCH99 new
	switch(m_pioThis->ictType)
	{
	case IntrinsicEdit:
		if(GetMultiLine())
			((CEdit *)this)->SetModify(bNewValue);
		break;
	default:
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
	}
}

long CIntrinsicControl::GetSelStart() 
{//**MARCH99 new
	long lRetval;
	int iStart, iEnd;
	DWORD dwVal;

	switch(m_pioThis->ictType)
	{
	case IntrinsicEdit:
		((CEdit *)this)->GetSel(iStart,iEnd);
		lRetval=iStart;
		break;
	case IntrinsicCombo:
		if(GetStyle()!=vbComboDropDownList)
		{
			AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
			return -1;
		}
		dwVal=((CComboBox *)this)->GetEditSel();
		lRetval= LOWORD(dwVal);
		break;
	default:
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return -1;
	}
	return lRetval;
}

void CIntrinsicControl::SetSelStart(long nNewValue) 
{//**MARCH99 new
	int iStart, iEnd;
	DWORD dwVal;

	switch(m_pioThis->ictType)
	{
	case IntrinsicEdit:
		((CEdit *)this)->GetSel(iStart,iEnd);
		((CEdit *)this)->SetSel((int)nNewValue,nNewValue+(iEnd-iStart));
		break;
	case IntrinsicCombo:
		if(GetStyle()!=vbComboDropDownList)
		{
			AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
			return ;
		}
		dwVal=((CComboBox *)this)->GetEditSel();
		((CComboBox *)this)->SetEditSel(nNewValue,nNewValue+(HIWORD(dwVal)-LOWORD(dwVal)));
		break;
	default:
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return ;
	}
}

long CIntrinsicControl::GetSelLength() 
{//**MARCH99 new
	long lRetval;
	int iStart, iEnd;
	DWORD dwVal;

	switch(m_pioThis->ictType)
	{
	case IntrinsicEdit:
		((CEdit *)this)->GetSel(iStart,iEnd);
		lRetval= (long) iEnd-iStart;
		break;
	case IntrinsicCombo:
		if(GetStyle()!=vbComboDropDownList)
		{
			AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
			return -1;
		}
		dwVal=((CComboBox *)this)->GetEditSel();
		lRetval= (long) HIWORD(dwVal)-LOWORD(dwVal);
		break;
	default:
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return -1;
	}
	return lRetval;
}

void CIntrinsicControl::SetSelLength(long nNewValue) 
{//**MARCH99 new
	int iStart, iEnd;
	DWORD dwVal;

	switch(m_pioThis->ictType)
	{
	case IntrinsicEdit:
		((CEdit *)this)->GetSel(iStart,iEnd);
		((CEdit *)this)->SetSel(iStart,iStart+nNewValue);
		break;
	case IntrinsicCombo:
		if(GetStyle()!=vbComboDropDownList)
		{
			AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
			return ;
		}
		dwVal=((CComboBox *)this)->GetEditSel();
		((CComboBox *)this)->SetEditSel(LOWORD(dwVal),LOWORD(dwVal)+nNewValue);
		break;
	default:
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return ;
	}
}

BSTR CIntrinsicControl::GetSelText() 
{//**MARCH99 new
	CString strResult;
	CString strAll;
	int iStart, iEnd;
	DWORD dwVal;

	GetWindowText(strAll);

	switch(m_pioThis->ictType)
	{
	case IntrinsicEdit:
		((CEdit *)this)->GetSel(iStart,iEnd);
		break;
	case IntrinsicCombo:
		if(GetStyle()!=vbComboDropDownList)
		{
			AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
			strResult="";
			break;
		}
		dwVal=((CComboBox *)this)->GetEditSel();
		iStart=LOWORD(dwVal);
		iEnd=HIWORD(dwVal);
		break;
	default:
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		strResult="";
		break;
	}
	strResult=strAll.Mid(iStart,iEnd-iStart);

	return strResult.AllocSysString();
}

void CIntrinsicControl::SetSelText(LPCTSTR lpszNewValue) 
{//**MARCH99 new
	CStringEx strResult;
	int iStart, iEnd;
	DWORD dwVal;

	GetWindowText(strResult);

	switch(m_pioThis->ictType)
	{
	case IntrinsicEdit:
		((CEdit *)this)->GetSel(iStart,iEnd);
		break;
	case IntrinsicCombo:
		if(GetStyle()!=vbComboDropDownList)
		{
			AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
			return ;
		}
		dwVal=((CComboBox *)this)->GetEditSel();
		iStart=LOWORD(dwVal);
		iEnd=HIWORD(dwVal);
		break;
	default:
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return ;
	}
	strResult.Delete(iStart,iEnd-iStart);
	strResult.Insert(iStart,lpszNewValue);
	SetWindowText(strResult);
}

BOOL CIntrinsicControl::GetLongFormat() 
{
	DWORD dwStyle;

	dwStyle=GetWindowLong(m_hWnd,GWL_STYLE);

	switch(m_pioThis->ictType)
	{
	case IntrinsicDate:
		return (dwStyle&DTS_LONGDATEFORMAT);
		break;
	default:
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return FALSE;
	}
	return FALSE;
}

void CIntrinsicControl::SetLongFormat(BOOL bNewValue) 
{
	DWORD dwStyle;

	dwStyle=GetWindowLong(m_hWnd,GWL_STYLE);

	switch(m_pioThis->ictType)
	{
	case IntrinsicDate:
		dwStyle&=~(DTS_LONGDATEFORMAT|DTS_SHORTDATEFORMAT);
		dwStyle|=bNewValue?DTS_LONGDATEFORMAT:DTS_SHORTDATEFORMAT;
		if (bNewValue)
		{//**JULY99 - fix for #182
#if(_WIN32_WCE != 200)  //**JULY99 - no Date/Time control in HPC
			((CDateTimeCtrl *)this)->SetFormat(TEXT("ddddd,MMMMM d, yyy"));
#endif
		}
		break;
	default:
		AfxThrowOleDispatchException(kEXCEPTION_NOTSUPPORTED,IDS_EXCEPTION_NOTSUPPORTED);
		return ;
	}
	SetWindowLong(m_hWnd,GWL_STYLE,dwStyle);
}

DATE CIntrinsicControl::GetMinDate() 
{
	COleDateTime dtMax,dtMin;

#if(_WIN32_WCE != 200)  //**MARCH99 - no Date/Time control in HPC
	((CDateTimeCtrl *)this)->GetRange(&dtMin,&dtMax);
#endif
	return (DATE) dtMin;
}

void CIntrinsicControl::SetMinDate(DATE newValue) 
{
	COleDateTime dtMax,dtMin,dtMinNew(newValue);

#if(_WIN32_WCE != 200)  //**MARCH99 - no Date/Time control in HPC
	((CDateTimeCtrl *)this)->GetRange(&dtMin,&dtMax);

	((CDateTimeCtrl *)this)->SetRange(&dtMinNew,&dtMax);
#endif

	return;
}

DATE CIntrinsicControl::GetMaxDate() 
{
	COleDateTime dtMax,dtMin;

#if(_WIN32_WCE != 200)  //**MARCH99 - no Date/Time control in HPC
	((CDateTimeCtrl *)this)->GetRange(&dtMin,&dtMax);
#endif

	return (DATE) dtMax;
}

void CIntrinsicControl::SetMaxDate(DATE newValue) 
{
	COleDateTime dtMax,dtMin,dtMaxNew(newValue);

#if(_WIN32_WCE != 200)  //**MARCH99 - Date/Time control in HPC
	((CDateTimeCtrl *)this)->GetRange(&dtMin,&dtMax);

	((CDateTimeCtrl *)this)->SetRange(&dtMin,&dtMaxNew);
#endif
	return;
}

DATE CIntrinsicControl::GetDate() 
{
	COleDateTime dt;

#if(_WIN32_WCE != 200)  //**MARCH99 - no Date/Time control in HPC
	((CDateTimeCtrl *)this)->GetTime(dt);
#endif
	return (DATE) dt;
}

void CIntrinsicControl::SetDate(DATE newValue) 
{
	COleDateTime dt(newValue);

#if(_WIN32_WCE != 200)  // No Date/Time control in HPC
	((CDateTimeCtrl *)this)->SetTime(dt);
#endif
}

short CIntrinsicControl::GetBorderStyle() 
{
	DWORD dwStyle = GetWindowLong(m_hWnd,GWL_STYLE);

	return (dwStyle & WS_BORDER)?1:0;
}

void CIntrinsicControl::SetBorderStyle(short nNewValue) 
{
	DWORD dwStyle = GetWindowLong(m_hWnd,GWL_STYLE);

	switch( m_pioThis->ictType )
	{
	case IntrinsicDate:
	case IntrinsicTime:
		return;
	}
	if(nNewValue)
		dwStyle|=WS_BORDER;
	else
		dwStyle&=~WS_BORDER;
	SetWindowLong(m_hWnd,GWL_STYLE,dwStyle);
	
	switch( m_pioThis->ictType )
	{
	case IntrinsicEdit:
		Reopen();

	}
}

OLE_HANDLE CIntrinsicControl::GetHwnd() 
{
	return (unsigned int) m_hWnd;
}

void CIntrinsicControl::SetHwnd(OLE_HANDLE nNewValue) 
{
	AfxThrowOleDispatchException(kEXCEPTION_READONLY,IDS_EXCEPTION_READONLY);
}

BSTR CIntrinsicControl::GetTag() 
{
	return m_cstrTag.AllocSysString();
}

void CIntrinsicControl::SetTag(LPCTSTR lpszNewValue) 
{
	m_cstrTag = lpszNewValue;
}

BOOL CIntrinsicControl::GetEnabled() 
{
	DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

	return (dwStyle & WS_DISABLED) ? FALSE : TRUE;
}

void CIntrinsicControl::SetEnabled(BOOL bNewValue) 
{
	DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

	dwStyle &= ~WS_DISABLED;
	if( !bNewValue )
		dwStyle |= WS_DISABLED;

	SetWindowLong( m_hWnd, GWL_STYLE, dwStyle );
	if( m_pioThis->ictType == IntrinsicEdit )
		Reopen();
}

short CIntrinsicControl::GetMin() 
{
	switch(m_pioThis->ictType)
	{
	case IntrinsicHScrollBar:
	case IntrinsicVScrollBar:
		{
			int nMin, nMax;
			((CScrollBar *) this)->GetScrollRange( &nMin, &nMax );
			return short(nMin);
			break;
		}
	default: //commandbutton, etc.
		return 0;
	}
}

void CIntrinsicControl::SetMin(short nNewValue) 
{
	switch(m_pioThis->ictType)
	{
	case IntrinsicHScrollBar:
	case IntrinsicVScrollBar:
		{
			int nMin, nMax;
			((CScrollBar *) this)->GetScrollRange( &nMin, &nMax );
			((CScrollBar *) this)->SetScrollRange( nNewValue, nMax );
			break;
		}
	}
}

short CIntrinsicControl::GetMax() 
{
	switch(m_pioThis->ictType)
	{
	case IntrinsicHScrollBar:
	case IntrinsicVScrollBar:
		{
			int nMin, nMax;
			((CScrollBar *) this)->GetScrollRange( &nMin, &nMax );
			return short(nMax);
			break;
		}
	default: //commandbutton, etc.
		return 0;
	}
}

void CIntrinsicControl::SetMax(short nNewValue) 
{
	switch(m_pioThis->ictType)
	{
	case IntrinsicHScrollBar:
	case IntrinsicVScrollBar:
		{
			int nMin, nMax;
			((CScrollBar *) this)->GetScrollRange( &nMin, &nMax );
			((CScrollBar *) this)->SetScrollRange( nMin, nNewValue );
			break;
		}
	}
}

short CIntrinsicControl::GetLargeChange() 
{
	switch(m_pioThis->ictType)
	{
	case IntrinsicHScrollBar:
	case IntrinsicVScrollBar:
		{
			SCROLLINFO si;
			((CScrollBar *) this)->GetScrollInfo( &si, SIF_PAGE );
			return si.nPage;
		}
	}
	return 0;
}

void CIntrinsicControl::SetLargeChange(short nNewValue) 
{
	switch(m_pioThis->ictType)
	{
	case IntrinsicHScrollBar:
	case IntrinsicVScrollBar:
		{
			SCROLLINFO si;
			si.cbSize = sizeof(SCROLLINFO);
			si.fMask = SIF_PAGE;
			si.nPage = nNewValue;
			((CScrollBar *) this)->SetScrollInfo( &si );
			break;
		}
	}
}

short CIntrinsicControl::GetSmallChange() 
{
	switch(m_pioThis->ictType)
	{
	case IntrinsicHScrollBar:
	case IntrinsicVScrollBar:
		return m_nSmallScroll;
	}
	return 0;
}

void CIntrinsicControl::SetSmallChange(short nNewValue) 
{
	switch(m_pioThis->ictType)
	{
	case IntrinsicHScrollBar:
	case IntrinsicVScrollBar:
		m_nSmallScroll = nNewValue;
		break;
	}
}

void CIntrinsicControl::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CString cstrTemp;
	SCROLLINFO sif;

	if( m_pioThis->ictType == IntrinsicHScrollBar )
		pScrollBar = (CScrollBar *)this;
	else if( m_pioThis->ictType == IntrinsicFrame )
	{
		pScrollBar->SendMessage( WM_HSCROLL, MAKEWPARAM( WORD(nSBCode), WORD(nPos) ), 0 );
		return;
	}
	else
	{
		CWnd::OnHScroll( nSBCode, nPos, pScrollBar );
		return;
	}

	// Get the minimum and maximum scroll-bar positions.
	pScrollBar->GetScrollInfo( &sif, SIF_ALL );

	// Get the current position of scroll box.
	int curpos = pScrollBar->GetScrollPos();

	// Determine the new position of scroll box.
	switch (nSBCode)
	{
	case SB_LEFT:    // Scroll to far left.
		curpos = sif.nMin;
		break;
	case SB_RIGHT:    // Scroll to far right.
		curpos = sif.nMax;
		break;
	case SB_ENDSCROLL:  // End scroll.
		break;
	case SB_LINELEFT:    // Scroll left.
		if( curpos > sif.nMin )
			curpos = max( sif.nMin, curpos - m_nSmallScroll );
		break;
	case SB_LINERIGHT:  // Scroll right.
		if( curpos < sif.nMax )
			curpos = min( sif.nMax, curpos + m_nSmallScroll );
		break;
	case SB_PAGELEFT:   // Scroll one page left.
		if( curpos > sif.nMin )
			curpos = max( sif.nMin, curpos - (int)sif.nPage );
		break;
	case SB_PAGERIGHT:    // Scroll one page right.
		if( curpos < sif.nMax )
			curpos = min( sif.nMax, curpos + (int)sif.nPage );
		break;
	case SB_THUMBPOSITION: // Scroll to absolute position. nPos is the position
		curpos = nPos;      // of the scroll box at the end of the drag 
		break;
	case SB_THUMBTRACK:		// Drag scroll box to specified position. nPos is the
		curpos = nPos;		// position that the scroll box has been dragged to.
		break;
	}

	// Set the new position of the thumb (scroll box).
	pScrollBar->SetScrollPos(curpos);

//	if( m_pioThis->ictType != IntrinsicHScrollBar )
//		CWnd::OnHScroll(nSBCode, nPos, pScrollBar);
//	else
		pENGINE->SendScriptMessage( BuildMessage( _T("change"), cstrTemp ), VT_EMPTY, 0, 0 );
}

void CIntrinsicControl::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CString cstrTemp;
	SCROLLINFO sif;

	if( m_pioThis->ictType == IntrinsicVScrollBar )
		pScrollBar = (CScrollBar *)this;
	else if( m_pioThis->ictType == IntrinsicFrame )
	{
		pScrollBar->SendMessage( WM_VSCROLL, MAKEWPARAM( WORD(nSBCode), WORD(nPos) ), 0 );
		return;
	}
	else
	{
		CWnd::OnHScroll( nSBCode, nPos, pScrollBar );
		return;
	}
	
	// Get the minimum and maximum scroll-bar positions.
	pScrollBar->GetScrollInfo( &sif, SIF_ALL );

	// Get the current position of scroll box.
	int curpos = pScrollBar->GetScrollPos();

	// Determine the new position of scroll box.
	switch (nSBCode)
	{
	case SB_TOP:    // Scroll to far left.
		curpos = sif.nMin;
		break;
	case SB_BOTTOM:    // Scroll to far right.
		curpos = sif.nMax;
		break;
	case SB_ENDSCROLL:  // End scroll.
		break;
	case SB_LINEUP:    // Scroll left.
		if( curpos > sif.nMin )
			curpos = max( sif.nMin, curpos - m_nSmallScroll );
		break;
	case SB_LINEDOWN:  // Scroll right.
		if( curpos < sif.nMax )
			curpos = min( sif.nMax, curpos + m_nSmallScroll );
		break;
	case SB_PAGEUP:   // Scroll one page left.
		if( curpos > sif.nMin )
			curpos = max( sif.nMin, curpos - (int)sif.nPage );
		break;
	case SB_PAGEDOWN:    // Scroll one page right.
		if( curpos < sif.nMax )
			curpos = min( sif.nMax, curpos + (int)sif.nPage );
		break;
	case SB_THUMBPOSITION: // Scroll to absolute position. nPos is the position
		curpos = nPos;      // of the scroll box at the end of the drag 
		break;
	case SB_THUMBTRACK:		// Drag scroll box to specified position. nPos is the
		curpos = nPos;		// position that the scroll box has been dragged to.
		break;
	}

	// Set the new position of the thumb (scroll box).
	pScrollBar->SetScrollPos(curpos);

//	if( m_pioThis->ictType != IntrinsicVScrollBar )
//		CWnd::OnVScroll(nSBCode, nPos, pScrollBar);
//	else
		pENGINE->SendScriptMessage(BuildMessage(_T("change"),cstrTemp),VT_EMPTY,0,0);
}

BOOL CIntrinsicControl::GetGroup() 
{
	DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

	return (dwStyle & WS_GROUP) ? TRUE : FALSE;
}

void CIntrinsicControl::SetGroup(BOOL bNewValue) 
{
	DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

	dwStyle &= ~WS_GROUP;
	if( bNewValue )
		dwStyle |= WS_GROUP;

	SetWindowLong( m_hWnd, GWL_STYLE, dwStyle );
}

OLE_HANDLE CIntrinsicControl::GetParentHWnd() 
{
	return (unsigned int)GetParent();
}

void CIntrinsicControl::SetParentHWnd(OLE_HANDLE nNewValue) 
{
	SetParent( FromHandle( HWND(nNewValue) ) );
}

long CIntrinsicControl::doGetWindowLong(short nLong) 
{
	switch( nLong )
	{
	case 0:	 return GetWindowLong( m_hWnd, GWL_STYLE );
	case 1:  return GetWindowLong( m_hWnd, GWL_EXSTYLE );
	default: return 0;
	}
}

void CIntrinsicControl::doSetWindowLong(short nLong, long nNewValue) 
{
	switch( nLong )
	{
	case 0:	 SetWindowLong( m_hWnd, GWL_STYLE, nNewValue ); break;
	case 1:  SetWindowLong( m_hWnd, GWL_EXSTYLE, nNewValue ); break;
	default: ;
	}
}

long CIntrinsicControl::doGetTimer() 
{
	return 0;
}

void CIntrinsicControl::doSetTimer(long nNewValue) 
{
	m_nTimerDuration = UINT(nNewValue);
	if( m_nTimerDuration == 0 )
		KillTimer( m_nTimer );
	else
		m_nTimer = SetTimer( 1, m_nTimerDuration, 0 );
}

void CIntrinsicControl::OnTimer(UINT nIDEvent) 
{
	CString strEvent;
	pENGINE->SendScriptMessage( BuildMessage( _T("timer"), strEvent ), VT_EMPTY, 0, 0 );
	CWnd::OnTimer(nIDEvent);
}

long CIntrinsicControl::GetItemData(short nIndex) 
{
	switch( m_pioThis->ictType )
	{
	case IntrinsicCombo:
		return ((CComboBox *) this)->GetItemData( nIndex );
		break;
	case IntrinsicList:
		return ((CListBox *) this)->GetItemData( nIndex );
		break;
	}
	return 0;
}

void CIntrinsicControl::SetItemData(short nIndex, long nNewValue) 
{
	switch( m_pioThis->ictType )
	{
	case IntrinsicCombo:
		((CComboBox *) this)->SetItemData( nIndex, nNewValue );
		break;
	case IntrinsicList:
		((CListBox *) this)->SetItemData( nIndex, nNewValue );
		break;
	}
}

BOOL CIntrinsicControl::GetDefault() 
{
	if( m_pioThis->ictType == IntrinsicButton )
	{
		DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

		return ( dwStyle & BS_DEFPUSHBUTTON ) ? true : false;
	}
	return false;
}

void CIntrinsicControl::SetDefault(BOOL bNewValue) 
{
	if( m_pioThis->ictType == IntrinsicButton )
	{
		DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

		dwStyle &= ~BS_DEFPUSHBUTTON;
		if( bNewValue )
			dwStyle |= BS_DEFPUSHBUTTON;

		SetWindowLong( m_hWnd, GWL_STYLE, dwStyle );
	}
}

BOOL CIntrinsicControl::GetNumbersOnly() 
{
	if( m_pioThis->ictType == IntrinsicEdit )
	{
		DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

		return ( dwStyle & ES_NUMBER ) ? true : false;
	}
	return false;
}

void CIntrinsicControl::SetNumbersOnly(BOOL bNewValue) 
{
	if( m_pioThis->ictType == IntrinsicEdit )
	{
		DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

		dwStyle &= ~ES_NUMBER;
		if( bNewValue )
			dwStyle |= ES_NUMBER;

		SetWindowLong( m_hWnd, GWL_STYLE, dwStyle );
	}
}

BOOL CIntrinsicControl::GetLowercaseOnly() 
{
	DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

	switch( m_pioThis->ictType )
	{
	case IntrinsicEdit:
		return ( dwStyle & ES_LOWERCASE ) ? true : false;
	case IntrinsicCombo:
		return ( dwStyle & CBS_LOWERCASE ) ? true : false;
	}
	return false;
}

void CIntrinsicControl::SetLowercaseOnly(BOOL bNewValue) 
{
	DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

	switch( m_pioThis->ictType )
	{
	case IntrinsicEdit:
		dwStyle &= ~ES_LOWERCASE;
		if( bNewValue )
			dwStyle |= ES_LOWERCASE;
		break;
	case IntrinsicCombo:
		dwStyle &= ~CBS_LOWERCASE;
		if( bNewValue )
			dwStyle |= CBS_LOWERCASE;
		break;
	default: return;
	}
	SetWindowLong( m_hWnd, GWL_STYLE, dwStyle );
}

BOOL CIntrinsicControl::GetUppercaseOnly() 
{
	DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

	switch( m_pioThis->ictType )
	{
	case IntrinsicEdit:
		return ( dwStyle & ES_UPPERCASE ) ? true : false;
	case IntrinsicCombo:
		return ( dwStyle & CBS_UPPERCASE ) ? true : false;
	}
	return false;
}

void CIntrinsicControl::SetUppercaseOnly(BOOL bNewValue) 
{
	DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

	switch( m_pioThis->ictType )
	{
	case IntrinsicEdit:
		dwStyle &= ~ES_UPPERCASE;
		if( bNewValue )
			dwStyle |= ES_UPPERCASE;
		break;
	case IntrinsicCombo:
		dwStyle &= ~CBS_UPPERCASE;
		if( bNewValue )
			dwStyle |= CBS_UPPERCASE;
		break;
	default: return;
	}
	SetWindowLong( m_hWnd, GWL_STYLE, dwStyle );
}

BOOL CIntrinsicControl::GetLocked() 
{
	DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

	switch( m_pioThis->ictType )
	{
	case IntrinsicEdit:
		// MMD 2005-07-17
		return (((CEdit *)this)->GetStyle() & ES_READONLY ) ? true : false;
		return ( dwStyle & ES_READONLY ) ? true : false;
//	case IntrinsicCombo:
//		return ( dwStyle & CBS_READONLY ) ? true : false;
	}
	return false;
}

void CIntrinsicControl::SetLocked(BOOL bNewValue) 
{
	DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

	switch( m_pioThis->ictType )
	{
	case IntrinsicEdit:
		// MMD 2005-07-17
		((CEdit *)this)->SetReadOnly( bNewValue );
		return;
//		dwStyle &= ~ES_READONLY;
//		if( bNewValue )
//			dwStyle |= ES_READONLY;
		break;
//	case IntrinsicCombo:
//		dwStyle &= ~CBS_READONLY;
//		if( bNewValue )
//			dwStyle |= CBS_READONLY;
//		break;
	default: return;
	}
	SetWindowLong( m_hWnd, GWL_STYLE, dwStyle );
}

BOOL CIntrinsicControl::GetMultiSelect() 
{
	if( m_pioThis->ictType == IntrinsicList)
	{
		DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

		return ( dwStyle & LBS_MULTIPLESEL ) ? true : false;
	}
	return false;
}

void CIntrinsicControl::SetMultiSelect(BOOL bNewValue) 
{
	if( m_pioThis->ictType == IntrinsicList)
	{
		DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

		dwStyle &= ~LBS_MULTIPLESEL;
		if( bNewValue )
			dwStyle |= LBS_MULTIPLESEL;

		SetWindowLong( m_hWnd, GWL_STYLE, dwStyle );
		Reopen();
	}
}

BOOL CIntrinsicControl::GetPassword() 
{
	if( m_pioThis->ictType == IntrinsicEdit )
	{
		DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

		return ( dwStyle & ES_PASSWORD ) ? true : false;
	}
	return false;
}

void CIntrinsicControl::SetPassword(BOOL bNewValue) 
{
	if( m_pioThis->ictType == IntrinsicEdit )
	{
		DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

		dwStyle &= ~ES_PASSWORD;
		if( bNewValue )
			dwStyle |= ES_PASSWORD;

		SetWindowLong( m_hWnd, GWL_STYLE, dwStyle );
		Reopen();
	}
}

BOOL CIntrinsicControl::GetRedraw() 
{
	switch( m_pioThis->ictType )
	{
	case IntrinsicList:
	case IntrinsicCombo:
		DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

		return ( dwStyle & LBS_NOREDRAW ) ? true : false;
	}
	return false;
}

void CIntrinsicControl::SetRedraw(BOOL bNewValue) 
{
	switch( m_pioThis->ictType )
	{
	case IntrinsicList:
	case IntrinsicCombo:
		SendMessage( WM_SETREDRAW, (WPARAM)bNewValue, (LPARAM)0 );
		break;
	}
}

long CIntrinsicControl::GetSelCount() 
{
	if( m_pioThis->ictType == IntrinsicList)
		return ((CListBox *)this)->GetSelCount();
	return 0;
}

BOOL CIntrinsicControl::GetSelected(short nIndex) 
{
	if( m_pioThis->ictType == IntrinsicList)
		return ( ((CListBox *)this)->GetSel( nIndex ) > 0 ) ? true : false;
	return false;
}

void CIntrinsicControl::SetSelected(short nIndex, BOOL bNewValue) 
{
	if( m_pioThis->ictType == IntrinsicList)
		((CListBox *)this)->SetSel( nIndex, bNewValue );
}

long CIntrinsicControl::GetTopIndex() 
{
	switch( m_pioThis->ictType )
	{
	case IntrinsicList:
		return ((CListBox *)this)->GetTopIndex();
	case IntrinsicCombo:
		return ((CComboBox *)this)->GetTopIndex();
	}
	return false;
}

void CIntrinsicControl::SetTopIndex(long nNewValue) 
{
	switch( m_pioThis->ictType )
	{
	case IntrinsicList:
		((CListBox *)this)->SetTopIndex( nNewValue );
		break;
	case IntrinsicCombo:
		((CComboBox *)this)->SetTopIndex( nNewValue );
		break;
	}
}

BOOL CIntrinsicControl::GetUseMnemonic() 
{
	if( m_pioThis->ictType == IntrinsicStatic )
	{
		DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

		return ( dwStyle & SS_NOPREFIX ) ? false : true;
	}
	return false;
}

void CIntrinsicControl::SetUseMnemonic(BOOL bNewValue) 
{
	if( m_pioThis->ictType == IntrinsicStatic )
	{
		DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

		dwStyle &= ~SS_NOPREFIX;
		if( !bNewValue )
			dwStyle |= SS_NOPREFIX;

		SetWindowLong( m_hWnd, GWL_STYLE, dwStyle );
	}
}

BOOL CIntrinsicControl::GetHideSelection() 
{
	if( m_pioThis->ictType == IntrinsicEdit )
	{
		DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

		return ( dwStyle & ES_NOHIDESEL ) ? false : true;
	}
	return false;
}

void CIntrinsicControl::SetHideSelection(BOOL bNewValue) 
{
	if( m_pioThis->ictType == IntrinsicStatic )
	{
		DWORD dwStyle = GetWindowLong( m_hWnd, GWL_STYLE );

		dwStyle &= ~ES_NOHIDESEL;
		if( !bNewValue )
			dwStyle |= ES_NOHIDESEL;

		SetWindowLong( m_hWnd, GWL_STYLE, dwStyle );
	}
}

void CIntrinsicControl::SetSpinBox(BOOL bNewValue) 
{
	// A SpinBox is implemented by having a separate control which is a buddy to a listbox.
	// This code creates the SpinBox control and uses SetMessage to make it a buddy.
	if( (m_pioThis->ictType == IntrinsicList) & bNewValue)
	{
		if (m_cstrParent != "not on form")
			pENGINE->RunScript(_T("AddObject \"SpinBox\",\""+m_cstrName+"_SpinBox\",0,0,0,0,"+m_cstrParent), VT_EMPTY,0,0);
		else
			pENGINE->RunScript(_T("AddObject \"SpinBox\",\""+m_cstrName+"_SpinBox\",0,0,0,0"), VT_EMPTY,0,0);

		//1129 = WM_USER + UDM_SETBUDDY
		pENGINE->RunScript( _T("SendMessage "+m_cstrName+"_SpinBox.hwnd,1129,"+m_cstrName+".hwnd,0"), VT_EMPTY,0,0);
	}
}
